/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.objmgr.cec;

import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.fsp.cmdhelpers.FspCmdHelper;
import com.ibm.hsc.fsp.cmdhelpers.FspTaggedIosForOs400;
import com.ibm.hsc.fsp.cmdhelpers.FspVspAttr;
import com.ibm.hsc.indication.server.HSCEventIndicationMgr;
import com.ibm.hsc.objmgr.cec.OmCecMgr;
import com.ibm.hsc.objmgr.nvram.PIHMCSaveArea;
import java.util.Hashtable;
import java.util.Vector;
import org.snia.wbem.cim.UnsignedInt16;
import org.snia.wbem.cim.UnsignedInt32;
import org.snia.wbem.cim.UnsignedInt8;

public class OmCecMgmUtils {
    private OmCecMgr mCecMgr;
    private FspCmdHelper mCmdHelper;
    private HSCEventIndicationMgr mIndMgr = null;

    OmCecMgmUtils(OmCecMgr omCecMgr) {
        this.mCecMgr = omCecMgr;
        this.mCmdHelper = omCecMgr.getCmdHelper();
        this.mIndMgr = HSCEventIndicationMgr.getInstance();
    }

    String createMgmPartition() throws PIHscServerException {
        System.out.println("createMgmPartition");
        int n = 1;
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(n);
        UnsignedInt8 unsignedInt8 = this.mCmdHelper.getLparSlotDefinitionState(unsignedInt16);
        short s = unsignedInt8.shortValue();
        String string = this.mCmdHelper.getLparUserDefName(unsignedInt16);
        int n2 = 0;
        System.out.println("lpar definition state: " + s);
        if (s == 2) {
            System.out.println("MGM: PARTITION_TYPE_RPA");
            n2 = 1;
        } else if (s == 4) {
            System.out.println("MGM: PARTITION_TYPE_RPA_IOSERVER");
            n2 = 65;
        } else if (s == 130) {
            System.out.println("MGM: PARTITION_TYPE_OS400");
            n2 = 129;
        } else {
            System.out.println("MGM: INVALID_PARTITION_OS_TYPE");
            throw new PIHscServerException("0601", null);
        }
        PIHMCSaveArea pIHMCSaveArea = this.mCecMgr.getSaveArea();
        try {
            System.out.println("lparIndex=" + n);
            System.out.println("userDefName=" + string);
            System.out.println("osType=" + n2);
            pIHMCSaveArea.setPartitionInfo(n, string, (byte)n2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("05EB", null);
            }
            throw (PIHscServerException)throwable;
        }
        try {
            this.createMgmProfile(n2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (!(throwable instanceof PIHscServerException)) {
                throw new PIHscServerException("07DB", null);
            }
            throw (PIHscServerException)throwable;
        }
        return string;
    }

    private void createMgmProfile(int n) throws PIHscServerException {
        int n2 = 1;
        String string = "1*" + this.mCecMgr.getCecName();
        Vector vector = new Vector();
        UnsignedInt8 unsignedInt8 = new UnsignedInt8(0);
        UnsignedInt16 unsignedInt16 = new UnsignedInt16(0);
        String string2 = "default_profile";
        String string3 = "65535";
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("PartitionCreationClassName", "IBMHSC_Partition");
        hashtable.put("PartitionName", string);
        hashtable.put("SettingID", string3);
        hashtable.put("UserDefinedName", string2);
        hashtable.put("FullSysPartProf", new UnsignedInt8(1));
        hashtable.put("DesiredCPUCount", unsignedInt16);
        hashtable.put("MinimumCPUCount", unsignedInt16);
        hashtable.put("MaximumCPUCount", unsignedInt16);
        hashtable.put("DesiredMemory", new UnsignedInt32(128L));
        hashtable.put("MinimumMemory", new UnsignedInt32(128L));
        hashtable.put("MaximumMemory", new UnsignedInt32(128L));
        hashtable.put("ProcMode", new UnsignedInt8(255));
        hashtable.put("SharingMode", unsignedInt8);
        hashtable.put("IOSlots", vector);
        hashtable.put("IORequirement", vector);
        hashtable.put("IOPoolIDs", vector);
        hashtable.put("BootMode", new UnsignedInt8(1));
        hashtable.put("SFPSurveillance", unsignedInt8);
        hashtable.put("AutoIPLEnabled", unsignedInt8);
        hashtable.put("HostingPartitions", vector);
        hashtable.put("VirtualOptiConnectPool", unsignedInt8);
        hashtable.put("HSLOptiConnectPool", unsignedInt8);
        hashtable.put("MaxVirtualSlots", new UnsignedInt16(2));
        hashtable.put("VirSerialServerLPARs", vector);
        hashtable.put("VirSerialServerSlotNum", vector);
        hashtable.put("VirSerialAdapters", vector);
        hashtable.put("VirSerialDeviceAttributes", vector);
        hashtable.put("VirSerialSupportHMCClients", vector);
        hashtable.put("VirSerialSlotReqDesAttribute", vector);
        hashtable.put("VirSCSIServerLPARs", vector);
        hashtable.put("VirSCSIServerSlotNum", vector);
        hashtable.put("VirSCSIAdapters", vector);
        hashtable.put("VirSCSIDeviceAttributes", vector);
        hashtable.put("VirSCSISupportHMCClients", vector);
        hashtable.put("VirSCSISlotReqDesAttribute", vector);
        hashtable.put("SMCAVirSlotNum", vector);
        hashtable.put("SMCADRCIndex", vector);
        hashtable.put("SMCARIOBus", vector);
        hashtable.put("SMCARemoteLparID", vector);
        hashtable.put("SMCARemoteVirSlotNum", vector);
        hashtable.put("VirtualLanSlotIDs", vector);
        hashtable.put("IEEE", vector);
        hashtable.put("VLANTrunkAdapter", vector);
        hashtable.put("VLANSlotReqDesAttribute", vector);
        hashtable.put("PVLANID", vector);
        hashtable.put("AddVlanNum", vector);
        FspVspAttr fspVspAttr = this.mCecMgr.getCmdHelper().getLparVspAttributes(new UnsignedInt16(n2));
        if (fspVspAttr != null) {
            hashtable.put("BootMode", fspVspAttr.getBootMode());
            hashtable.put("AutoIPLEnabled", fspVspAttr.getIplSource());
        }
        if (n == 129) {
            FspTaggedIosForOs400 fspTaggedIosForOs400 = this.mCecMgr.getCmdHelper().getTaggedIosForOs400(new UnsignedInt16(n2));
            Hashtable hashtable2 = this.mCecMgr.getPhyIODrcIndexTable();
            Vector<Boolean> vector2 = new Vector<Boolean>();
            vector2.setSize(6);
            UnsignedInt32 unsignedInt32 = fspTaggedIosForOs400.getLoadSrcDrcIndex();
            hashtable.put("LoadSourceDRCIndex", unsignedInt32);
            long l = unsignedInt32.longValue();
            if (l == 0L || hashtable2.containsKey(unsignedInt32)) {
                vector2.setElementAt(new Boolean(false), 0);
            } else {
                vector2.setElementAt(new Boolean(true), 0);
            }
            unsignedInt32 = fspTaggedIosForOs400.getAltLoadSrcDrcIndex();
            hashtable.put("AltLoadSourceDRCIndex", unsignedInt32);
            l = unsignedInt32.longValue();
            if (l == 0L || hashtable2.containsKey(unsignedInt32)) {
                vector2.setElementAt(new Boolean(false), 1);
            } else {
                vector2.setElementAt(new Boolean(true), 1);
            }
            unsignedInt32 = fspTaggedIosForOs400.getConsoleDrcIndex();
            hashtable.put("ConsoleDRCIndex", unsignedInt32);
            l = unsignedInt32.longValue();
            if (l == 0L || hashtable2.containsKey(unsignedInt32)) {
                vector2.setElementAt(new Boolean(false), 2);
            } else {
                vector2.setElementAt(new Boolean(true), 2);
            }
            unsignedInt32 = fspTaggedIosForOs400.getAltConsoleDrcIndex();
            hashtable.put("AltConsoleDRCIndex", unsignedInt32);
            l = unsignedInt32.longValue();
            if (l == 0L || hashtable2.containsKey(unsignedInt32)) {
                vector2.setElementAt(new Boolean(false), 3);
            } else {
                vector2.setElementAt(new Boolean(true), 3);
            }
            unsignedInt32 = fspTaggedIosForOs400.getEcsDrcIndex();
            hashtable.put("ECSDRCIndex", unsignedInt32);
            l = unsignedInt32.longValue();
            if (l == 0L || hashtable2.containsKey(unsignedInt32)) {
                vector2.setElementAt(new Boolean(false), 4);
            } else {
                vector2.setElementAt(new Boolean(true), 4);
            }
            unsignedInt32 = fspTaggedIosForOs400.getOldAltLoadSrcDrcIndex();
            l = unsignedInt32.longValue();
            if (l == 0L || hashtable2.containsKey(unsignedInt32)) {
                vector2.setElementAt(new Boolean(false), 5);
            } else {
                vector2.setElementAt(new Boolean(true), 5);
            }
            hashtable.put("TaggedIOInfo", vector2);
        }
        int n3 = this.mCecMgr.getSaveArea().createLPARProfile(n2, string2, hashtable);
        this.mCecMgr.getSaveArea().setDefaultLPARProfile(n2, n3);
    }
}

